/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.logging.LogUtils;
import com.wildfire.main.WildfireEventHandler;
import com.wildfire.main.WildfireGenderClient;
import com.wildfire.main.WildfireHelper;
import com.wildfire.main.config.GlobalConfig;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.main.networking.WildfireSync;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class WildfireGender
implements ModInitializer {
    public static final String MODID = "wildfire_gender";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final LoadingCache<UUID, PlayerConfig> CACHE;
    public static final UUID CREATOR_UUID;
    public static final List<UUID> CONTRIBUTOR_UUIDS;

    public void onInitialize() {
        WildfireSync.register();
        WildfireEventHandler.registerCommonEvents();
        GlobalConfig.INSTANCE.load();
    }

    @Nullable
    public static PlayerConfig getPlayerById(UUID id) {
        return (PlayerConfig)CACHE.getIfPresent((Object)id);
    }

    @NotNull
    public static PlayerConfig getOrAddPlayerById(UUID id) {
        return (PlayerConfig)CACHE.getUnchecked((Object)id);
    }

    static {
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (WildfireHelper.onClient()) {
            builder.expireAfterAccess(Duration.ofMinutes(15L));
        }
        CACHE = builder.build((CacheLoader)new CacheLoader<UUID, PlayerConfig>(){

            @NotNull
            public PlayerConfig load(@NotNull UUID key) {
                PlayerConfig config = new PlayerConfig(key);
                if (WildfireHelper.onClient() && key.version() == 4) {
                    WildfireGenderClient.loadGenderInfo(config, true, false);
                }
                return config;
            }
        });
        CREATOR_UUID = UUID.fromString("23b6feed-2dfe-4f2e-9429-863fd4adb946");
        CONTRIBUTOR_UUIDS = List.of(UUID.fromString("70336328-0de7-430e-8cba-2779e2a05ab5"), UUID.fromString("64e57307-72e5-4f43-be9c-181e8e35cc9b"), UUID.fromString("618a8390-51b1-43b2-a53a-ab72c1bbd8bd"), UUID.fromString("33feda66-c706-4725-8983-f62e5e6cbee7"), UUID.fromString("ad8ee68c-0aa1-47f9-b29f-f92fa1ef66dc"), UUID.fromString("8fb5e95d-7f41-4b4c-b8c5-4f15ea3fa2c1"), UUID.fromString("3f36f7e9-7459-43fe-87ce-4e8a5d47da80"), UUID.fromString("525b0455-15e9-49b7-b61d-f291e8ee6c5b"), UUID.fromString("6e0e0db3-19e9-4fa7-af76-a6d3651c57b9"));
    }
}

