/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.autoreconnectrf.gui.screen;

import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.api.controller.DropdownStringControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.string.IStringController;
import dev.isxander.yacl3.gui.controllers.string.StringController;
import dev.isxander.yacl3.gui.controllers.string.StringControllerElement;
import dev.terminalmc.autoreconnectrf.AutoReconnect;
import dev.terminalmc.autoreconnectrf.config.Config;
import dev.terminalmc.autoreconnectrf.gui.screen.ConfigScreenProvider;
import dev.terminalmc.autoreconnectrf.util.Localization;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import net.minecraft.class_9110;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YaclScreenProvider {
    static boolean regexIdsTemp;
    public static final List<String> DISCONNECT_KEYS;

    static class_437 getConfigScreen(class_437 parent) {
        Config.Options options = Config.options();
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder().title((class_2561)Localization.localized("name", new Object[0])).save(Config::save);
        ConfigCategory.Builder attemptsCat = ConfigCategory.createBuilder().name((class_2561)Localization.localized("option", "attempts", new Object[0]));
        attemptsCat.group((OptionGroup)ListOption.createBuilder().name((class_2561)Localization.localized("option", "attempts.delays", new Object[0])).description(OptionDescription.of((class_2561[])new class_2561[]{Localization.localized("option", "attempts.delays.tooltip", new Object[0])})).binding(Config.Options.delaysDefault.get(), () -> options.delays, val -> {
            options.delays = val;
        }).controller(option -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)option).min((Number)1)).formatValue(val -> Localization.localized("option", "attempts.delays.value", val))).initial((Object)0).insertEntriesAtEnd(true).minimumNumberOfEntries(1).build());
        attemptsCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "attempts.infinite", new Object[0])).description(OptionDescription.of((class_2561[])new class_2561[]{Localization.localized("option", "attempts.infinite.tooltip", new Object[0])})).binding((Object)false, () -> options.infinite, val -> {
            options.infinite = val;
        }).controller(BooleanControllerBuilder::create).build());
        ConfigCategory.Builder conditionsCat = ConfigCategory.createBuilder().name((class_2561)Localization.localized("option", "conditions", new Object[0]));
        conditionsCat.option((Option)LabelOption.createBuilder().lines(List.of(Localization.localized("option", "conditions.tooltip", new Object[0]))).build());
        conditionsCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "conditions.type", new Object[0])).description(OptionDescription.of((class_2561[])new class_2561[]{Localization.localized("option", "conditions.type.tooltip", Localization.localized("option", "conditions.type.positive", new Object[0]).method_27692(class_124.field_1060), Localization.localized("option", "conditions.type.negative", new Object[0]).method_27692(class_124.field_1061))})).binding((Object)false, () -> options.conditionType, val -> {
            options.conditionType = val;
        }).controller(option -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)option).formatValue(val2 -> val2 != false ? Localization.localized("option", "conditions.type.positive", new Object[0]) : Localization.localized("option", "conditions.type.negative", new Object[0]))).coloured(true)).build());
        conditionsCat.group((OptionGroup)ListOption.createBuilder().name((class_2561)Localization.localized("option", "conditions.keys", new Object[0])).description(OptionDescription.of((class_2561[])new class_2561[]{Localization.localized("option", "conditions.keys.tooltip", AutoReconnect.lastDcReasonKey == null ? Localization.localized("option", "conditions.last.none", new Object[0]) : String.format("\"%s\"", AutoReconnect.lastDcReasonKey))})).binding(Config.Options.conditionKeysDefault.get(), () -> options.conditionKeys, val -> {
            options.conditionKeys = val;
        }).controller(option -> DropdownStringControllerBuilder.create((Option)option).values(DISCONNECT_KEYS).allowAnyValue(true).allowEmptyValue(false)).initial((Object)"").insertEntriesAtEnd(true).build());
        conditionsCat.group((OptionGroup)ListOption.createBuilder().name((class_2561)Localization.localized("option", "conditions.patterns", new Object[0])).description(OptionDescription.of((class_2561[])new class_2561[]{Localization.localized("option", "conditions.patterns.tooltip", AutoReconnect.lastDcReasonStr == null ? Localization.localized("option", "conditions.last.none", new Object[0]) : String.format("\"%s\"", AutoReconnect.lastDcReasonStr))})).binding(Config.Options.conditionPatternsDefault.get(), () -> options.conditionPatterns, val -> {
            options.conditionPatterns = val;
        }).controller(option -> IRestrictedStringControllerBuilder.create((Option<String>)option).validator(val -> {
            try {
                Pattern.compile(val);
                return Optional.empty();
            }
            catch (PatternSyntaxException e) {
                return Optional.of(YaclScreenProvider.fixRegexMessage(e.getMessage()));
            }
        })).initial((Object)"").insertEntriesAtEnd(true).build());
        ConfigCategory.Builder messagesCat = ConfigCategory.createBuilder().name((class_2561)Localization.localized("option", "messages", new Object[0]));
        messagesCat.option((Option)ButtonOption.createBuilder().name((class_2561)Localization.localized("option", "messages.instance.add", new Object[0]).method_27692(class_124.field_1060)).action((yaclScreen, buttonOption) -> {
            options.autoMessages.add(new Config.AutoMessage());
            YaclScreenProvider.reload(yaclScreen, parent);
        }).build());
        int i = options.autoMessages.size();
        for (Config.AutoMessage am : options.autoMessages.reversed()) {
            OptionGroup.Builder amGroup = OptionGroup.createBuilder();
            amGroup.name((class_2561)Localization.localized("option", "messages.instance", i--));
            amGroup.description(OptionDescription.of((class_2561[])new class_2561[]{Localization.localized("option", "messages.instance.tooltip", new Object[0])}));
            amGroup.option((Option)ButtonOption.createBuilder().name((class_2561)Localization.localized("option", "messages.instance.delete", new Object[0]).method_27692(class_124.field_1061)).action((screen, buttonOption) -> {
                options.autoMessages.remove(am);
                YaclScreenProvider.reload(screen, parent);
            }).build());
            amGroup.option(Option.createBuilder().name((class_2561)Localization.localized("option", "messages.instance.id", new Object[0])).description(OptionDescription.of((class_2561[])new class_2561[]{Localization.localized("option", "messages.instance.id.tooltip", new Object[0])})).binding((Object)"", () -> am.id, val -> {
                am.id = val;
            }).controller(option -> IRestrictedStringControllerBuilder.create((Option<String>)option).validator(val -> {
                if (regexIdsTemp) {
                    try {
                        Pattern.compile(val);
                        return Optional.empty();
                    }
                    catch (PatternSyntaxException e) {
                        return Optional.of(YaclScreenProvider.fixRegexMessage(e.getMessage()));
                    }
                }
                return Optional.empty();
            })).build());
            amGroup.option(Option.createBuilder().name((class_2561)Localization.localized("option", "messages.instance.delay", new Object[0])).description(OptionDescription.of((class_2561[])new class_2561[]{Localization.localized("option", "messages.instance.delay.tooltip", new Object[0])})).binding((Object)Float.valueOf(1.0f), () -> Float.valueOf(am.delay), val -> {
                am.delay = val.floatValue();
            }).controller(option -> ((FloatFieldControllerBuilder)FloatFieldControllerBuilder.create((Option)option).min((Number)Float.valueOf(0.0f))).formatValue(val -> Localization.localized("option", "messages.instance.delay.value", val))).build());
            messagesCat.group(amGroup.build());
            messagesCat.group((OptionGroup)ListOption.createBuilder().name((class_2561)Localization.localized("option", "messages.instance.messages", new Object[0])).description(OptionDescription.of((class_2561[])new class_2561[]{Localization.localized("option", "messages.instance.messages.tooltip", new Object[0])})).binding(Config.AutoMessage.messagesDefault.get(), () -> am.messages, val -> {
                am.messages = val;
            }).controller(StringControllerBuilder::create).initial((Object)"").insertEntriesAtEnd(true).build());
        }
        ConfigCategory.Builder miscCat = ConfigCategory.createBuilder().name((class_2561)Localization.localized("option", "misc", new Object[0]));
        miscCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "misc.commandSigning", new Object[0])).description(OptionDescription.of((class_2561[])new class_2561[]{Localization.localized("option", "misc.commandSigning.tooltip", new Object[0])})).binding((Object)false, () -> options.commandSigning, val -> {
            options.commandSigning = val;
        }).controller(BooleanControllerBuilder::create).build());
        miscCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "misc.regexIds", new Object[0])).description(OptionDescription.of((class_2561[])new class_2561[]{Localization.localized("option", "misc.regexIds.tooltip", new Object[0])})).binding((Object)false, () -> options.regexIds, val -> {
            options.regexIds = val;
        }).addListener((option, event) -> {
            regexIdsTemp = (Boolean)option.pendingValue();
        }).controller(BooleanControllerBuilder::create).build());
        builder.category(attemptsCat.build());
        builder.category(conditionsCat.build());
        builder.category(messagesCat.build());
        builder.category(miscCat.build());
        YetAnotherConfigLib yacl = builder.build();
        return yacl.generateScreen(parent);
    }

    private static void reload(YACLScreen screen, class_437 parent) {
        try {
            int tab;
            int n = tab = screen.tabNavigationBar == null ? 0 : screen.tabNavigationBar.getTabs().indexOf((Object)screen.tabManager.method_48614());
            if (tab == -1) {
                tab = 0;
            }
            screen.finishOrSave();
            screen.method_25419();
            YACLScreen newScreen = (YACLScreen)ConfigScreenProvider.getConfigScreen(parent);
            newScreen.method_25423(class_310.method_1551(), screen.field_22789, screen.field_22790);
            try {
                newScreen.tabNavigationBar.method_48987(tab, false);
            }
            catch (IndexOutOfBoundsException e) {
                AutoReconnect.LOG.warn("YACL reload hack attempted to select tab {} but max index was {}", tab, newScreen.tabNavigationBar.getTabs().size() - 1);
            }
            class_310.method_1551().method_1507((class_437)newScreen);
        }
        catch (Exception e) {
            class_310.method_1551().method_1507(parent);
            AutoReconnect.LOG.error("YACL reload hack failed with exception\n{}", e);
        }
    }

    public static String fixRegexMessage(String str) {
        Matcher indexMatcher;
        if ((str = str.replaceAll("\\u000D", "")).endsWith("^") && (indexMatcher = Pattern.compile("near index (\\d+)\n").matcher(str)).find()) {
            class_327 font = class_310.method_1551().field_1772;
            int index = Integer.parseInt(indexMatcher.group(1));
            int startPos = indexMatcher.end();
            int cursorPos = startPos + index;
            int cursorOffset = font.method_1727(str.substring(startPos, cursorPos));
            char[] charArray = new char[cursorOffset / font.method_1727(" ")];
            Arrays.fill(charArray, ' ');
            String newSpace = new String(charArray);
            Matcher cursorMatcher = Pattern.compile("\n( *\\^)$").matcher(str);
            if (cursorMatcher.find(cursorPos)) {
                String cursorLine = cursorMatcher.group(1);
                str = str.replaceAll(Pattern.quote(cursorLine) + "$", newSpace + "^");
            }
        }
        return str;
    }

    static {
        DISCONNECT_KEYS = List.of("disconnect.closed", "disconnect.disconnected", "disconnect.endOfStream", "disconnect.exceeded_packet_rate", "disconnect.genericReason", "disconnect.ignoring_status_request", "disconnect.loginFailed", "disconnect.loginFailedInfo", "disconnect.loginFailedInfo.insufficientPrivileges", "disconnect.loginFailedInfo.invalidSession", "disconnect.loginFailedInfo.serversUnavailable", "disconnect.loginFailedInfo.userBanned", "disconnect.lost", "disconnect.overflow", "disconnect.packetError", "disconnect.spam", "disconnect.timeout", "disconnect.transfer", "disconnect.unknownHost", "menu.custom_screen_info.disconnect", "multiplayer.disconnect.authservers_down", "multiplayer.disconnect.bad_chat_index", "multiplayer.disconnect.banned", "multiplayer.disconnect.banned_ip.reason", "multiplayer.disconnect.banned.reason", "multiplayer.disconnect.chat_validation_failed", "multiplayer.disconnect.duplicate_login", "multiplayer.disconnect.expired_public_key", "multiplayer.disconnect.flying", "multiplayer.disconnect.generic", "multiplayer.disconnect.idling", "multiplayer.disconnect.illegal_characters", "multiplayer.disconnect.incompatible", "multiplayer.disconnect.invalid_entity_attacked", "multiplayer.disconnect.invalid_packet", "multiplayer.disconnect.invalid_player_data", "multiplayer.disconnect.invalid_player_movement", "multiplayer.disconnect.invalid_public_key_signature", "multiplayer.disconnect.invalid_public_key_signature.new", "multiplayer.disconnect.invalid_vehicle_movement", "multiplayer.disconnect.ip_banned", "multiplayer.disconnect.kicked", "multiplayer.disconnect.missing_tags", "multiplayer.disconnect.name_taken", "multiplayer.disconnect.not_whitelisted", "multiplayer.disconnect.out_of_order_chat", "multiplayer.disconnect.outdated_client", "multiplayer.disconnect.outdated_server", "multiplayer.disconnect.server_full", "multiplayer.disconnect.server_shutdown", "multiplayer.disconnect.slow_login", "multiplayer.disconnect.too_many_pending_chats", "multiplayer.disconnect.transfers_disabled", "multiplayer.disconnect.unexpected_query_response", "multiplayer.disconnect.unsigned_chat", "multiplayer.disconnect.unverified_username", "multiplayer.requiredTexturePrompt.disconnect");
    }

    public static interface IRestrictedStringControllerBuilder
    extends ControllerBuilder<String> {
        public static IRestrictedStringControllerBuilder create(Option<String> option) {
            return new RestrictedStringControllerBuilder(option);
        }

        public IRestrictedStringControllerBuilder validator(Function<String, Optional<String>> var1);
    }

    private static class RestrictedStringControllerElement
    extends StringControllerElement {
        private final class_9110 tooltip = new class_9110();

        public RestrictedStringControllerElement(IStringController<?> control, YACLScreen screen, Dimension<Integer> dim, boolean instantApply) {
            super(control, screen, dim, instantApply);
        }

        public void setTooltip(@Nullable class_7919 tooltip) {
            this.tooltip.method_56138(tooltip);
        }

        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float delta) {
            super.method_25394(graphics, mouseX, mouseY, delta);
            this.tooltip.method_56142(graphics, mouseX, mouseY, super.method_25405((double)mouseX, (double)mouseY), super.method_25370(), super.method_48202());
        }
    }

    private static class RestrictedStringController
    extends StringController {
        @Nullable
        private final Function<String, Optional<String>> validator;
        @Nullable
        private String displayValue;
        @Nullable
        private RestrictedStringControllerElement widget;

        public RestrictedStringController(Option<String> option, @Nullable Function<String, Optional<String>> validator) {
            super(option);
            this.validator = validator;
        }

        public class_2561 formatValue() {
            if (this.displayValue == null) {
                return super.formatValue();
            }
            return class_2561.method_43470((String)this.displayValue).method_27692(class_124.field_1061);
        }

        public void setFromString(String value) {
            Optional<String> error;
            if (this.validator != null && (error = this.validator.apply(value)).isPresent()) {
                this.displayValue = value;
                if (this.widget != null) {
                    this.widget.setTooltip(class_7919.method_47407((class_2561)class_2561.method_43470((String)error.get())));
                }
                return;
            }
            this.displayValue = null;
            if (this.widget != null) {
                this.widget.setTooltip(null);
            }
            super.setFromString(value);
        }

        public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
            this.widget = new RestrictedStringControllerElement((IStringController<?>)this, screen, widgetDimension, true);
            return this.widget;
        }
    }

    public static class RestrictedStringControllerBuilder
    extends CustomAbstractControllerBuilder<String>
    implements IRestrictedStringControllerBuilder {
        private Function<String, Optional<String>> validator;

        public RestrictedStringControllerBuilder(Option<String> option) {
            super(option);
        }

        @Override
        public RestrictedStringControllerBuilder validator(Function<String, Optional<String>> validator) {
            this.validator = validator;
            return this;
        }

        public Controller<String> build() {
            return new RestrictedStringController((Option<String>)this.option, this.validator);
        }
    }

    public static abstract class CustomAbstractControllerBuilder<T>
    implements ControllerBuilder<T> {
        protected final Option<T> option;

        protected CustomAbstractControllerBuilder(Option<T> option) {
            this.option = option;
        }
    }
}

