/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.fabric.compat.replay;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import ru.dimaskama.webcam.client.DisplayingVideoManager;
import ru.dimaskama.webcam.client.KnownSourceClient;
import ru.dimaskama.webcam.client.KnownSourceManager;
import ru.dimaskama.webcam.client.fabric.compat.replay.ReplayWebcamMessage;
import ru.dimaskama.webcam.client.fabric.compat.replay.flashback.FlashbackCompat;
import ru.dimaskama.webcam.client.fabric.compat.replay.replaymod.ReplayModCompat;
import ru.dimaskama.webcam.net.KnownSource;
import ru.dimaskama.webcam.net.packet.CloseSourceS2CPacket;
import ru.dimaskama.webcam.net.packet.KnownSourcesS2CPacket;
import ru.dimaskama.webcam.net.packet.Packet;
import ru.dimaskama.webcam.net.packet.PermissionsS2CPacket;
import ru.dimaskama.webcam.net.packet.VideoS2CPacket;

public class ReplaysCompat {
    public static boolean SHOULD_APPLY = FlashbackCompat.IS_FLASHBACK_LOADED || ReplayModCompat.IS_REPLAYMOD_LOADED;

    public static void init() {
        if (SHOULD_APPLY) {
            PayloadTypeRegistry.playS2C().register(ReplayWebcamMessage.TYPE, ReplayWebcamMessage.STREAM_CODEC);
            ClientPlayNetworking.registerGlobalReceiver(ReplayWebcamMessage.TYPE, ReplaysCompat::onReplayWebcamMessage);
            FlashbackCompat.init();
            ReplayModCompat.init();
        }
    }

    public static void recordPacket(Packet packet) {
        if (SHOULD_APPLY) {
            boolean recordFlashback = FlashbackCompat.shouldRecord();
            boolean recordReplayMod = ReplayModCompat.shouldRecord();
            if (recordFlashback || recordReplayMod) {
                ReplayWebcamMessage.Video replayMessage;
                Packet packet2 = packet;
                Objects.requireNonNull(packet2);
                Packet packet3 = packet2;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VideoS2CPacket.class, CloseSourceS2CPacket.class, PermissionsS2CPacket.class, KnownSourcesS2CPacket.class}, (Object)packet3, n)) {
                    case 0: {
                        VideoS2CPacket video = (VideoS2CPacket)packet3;
                        Record record = new ReplayWebcamMessage.Video(video.source(), video.nal());
                        break;
                    }
                    case 1: {
                        CloseSourceS2CPacket closeSource = (CloseSourceS2CPacket)packet3;
                        Record record = new ReplayWebcamMessage.CloseSource(closeSource.sourceUuid());
                        break;
                    }
                    case 2: {
                        PermissionsS2CPacket permissions = (PermissionsS2CPacket)packet3;
                        Record record = new ReplayWebcamMessage.ViewPermission(permissions.view());
                        break;
                    }
                    case 3: {
                        KnownSourcesS2CPacket knownSources = (KnownSourcesS2CPacket)packet3;
                        Record record = new ReplayWebcamMessage.KnownSources(knownSources.sources());
                        break;
                    }
                    default: {
                        Record record = replayMessage = null;
                    }
                }
                if (replayMessage != null) {
                    if (FlashbackCompat.shouldRecord()) {
                        FlashbackCompat.record(replayMessage);
                    }
                    if (ReplayModCompat.shouldRecord()) {
                        ReplayModCompat.record(replayMessage);
                    }
                }
            }
        }
    }

    public static boolean isInReplay() {
        return SHOULD_APPLY && (FlashbackCompat.isInReplay() || ReplayModCompat.isInReplay());
    }

    private static void onReplayWebcamMessage(ReplayWebcamMessage msg, ClientPlayNetworking.Context context) {
        if (SHOULD_APPLY && (FlashbackCompat.shouldApplyReplayMessage(msg) || ReplayModCompat.shouldApplyReplayMessage(msg))) {
            ReplayWebcamMessage replayWebcamMessage = msg;
            Objects.requireNonNull(replayWebcamMessage);
            ReplayWebcamMessage replayWebcamMessage2 = replayWebcamMessage;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ReplayWebcamMessage.Video.class, ReplayWebcamMessage.CloseSource.class, ReplayWebcamMessage.ViewPermission.class, ReplayWebcamMessage.KnownSources.class}, (Object)replayWebcamMessage2, n)) {
                case 0: {
                    ReplayWebcamMessage.Video video = (ReplayWebcamMessage.Video)replayWebcamMessage2;
                    DisplayingVideoManager.INSTANCE.onVideoPacket(video.source(), video.nal());
                    break;
                }
                case 1: {
                    ReplayWebcamMessage.CloseSource closeSource = (ReplayWebcamMessage.CloseSource)replayWebcamMessage2;
                    DisplayingVideoManager.INSTANCE.remove(closeSource.sourceUuid());
                    break;
                }
                case 2: {
                    ReplayWebcamMessage.ViewPermission viewPermission = (ReplayWebcamMessage.ViewPermission)replayWebcamMessage2;
                    DisplayingVideoManager.INSTANCE.setViewPermission(viewPermission.view());
                    break;
                }
                case 3: {
                    ReplayWebcamMessage.KnownSources knownSources = (ReplayWebcamMessage.KnownSources)replayWebcamMessage2;
                    for (KnownSource knownSource : knownSources.sources()) {
                        KnownSourceManager.INSTANCE.add(new KnownSourceClient(knownSource));
                    }
                    break;
                }
            }
        }
    }
}

