/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client;

import com.mojang.util.UndashedUuid;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import ru.dimaskama.webcam.WebcamMod;
import ru.dimaskama.webcam.net.KnownSource;

public class KnownSourceClient {
    private final UUID uuid;
    private final String name;
    @Nullable
    private final class_1011 customIcon;
    @Nullable
    private class_2960 customIconId;
    private String nameForSearch;

    public KnownSourceClient(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
        this.customIcon = null;
    }

    public KnownSourceClient(KnownSource source) {
        this.uuid = source.getUuid();
        this.name = source.getName();
        byte[] customIconPixels = source.getCustomIcon();
        class_1011 customIcon = null;
        if (customIconPixels != null) {
            customIcon = new class_1011(16, 16, false);
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    int i = (y * 16 + x) * 4;
                    customIcon.method_4305(x, y, (customIconPixels[i] & 0xFF) << 24 | (customIconPixels[i + 1] & 0xFF) << 16 | (customIconPixels[i + 2] & 0xFF) << 8 | customIconPixels[i + 3] & 0xFF);
                }
            }
        }
        this.customIcon = customIcon;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public class_2960 getCustomIcon() {
        if (this.customIcon != null && this.customIconId == null) {
            class_2960 id = WebcamMod.id("custom_icon_" + UndashedUuid.toString((UUID)this.uuid));
            class_310.method_1551().method_1531().method_4616(id, (class_1044)new class_1043(() -> ((class_2960)id).method_12832(), this.customIcon));
            this.customIconId = id;
        }
        return this.customIconId;
    }

    public String getNameForSearch() {
        if (this.nameForSearch == null) {
            this.nameForSearch = this.name.toLowerCase(Locale.ROOT);
        }
        return this.nameForSearch;
    }

    public void close() {
        if (this.customIcon != null) {
            class_310.method_1551().execute(() -> {
                if (this.customIconId != null) {
                    class_310.method_1551().method_1531().method_4615(this.customIconId);
                } else {
                    this.customIcon.close();
                }
            });
        }
    }
}

