#include "/lib/all_the_libs.glsl"
#include "/generic/water.glsl"
in vec2 texcoord;
in vec4 glcolor;

flat in vec3 Normal;
flat in uint Material;

in vec3 PlayerPos;

#ifdef RSM
    /* DRAWBUFFERS:01 */
#else
    /* DRAWBUFFERS:0 */
#endif
layout(location = 0) out vec4 Color;
#ifdef RSM
    layout(location = 1) out vec4 ShadowNormal;
#endif

void main() {
    Color = texture(texture, texcoord) * glcolor;
    if (Color.a < 0.1) {
        discard;
        return;
    }

    if (Material == MATERIAL_WATER) {
        vec3 ScreenPos = vec3(gl_FragCoord.xy * shadowTexSize, gl_FragCoord.z);

        float Depth = gl_FragCoord.z;
        float Depth1 = texture(shadowtex1, ScreenPos.xy).x;

        vec3 ShadowPosUndistorted = undistort(ScreenPos * 2 - 1);
        vec3 NDCPos = vec3(ShadowPosUndistorted);
        vec3 NDCPos1 = vec3(ShadowPosUndistorted.xy, (Depth1 * 2 - 1) / 0.2);
        vec3 ViewPos = project_and_divide(shadowProjectionInverse, NDCPos);
        vec3 ViewPos1 = project_and_divide(shadowProjectionInverse, NDCPos1);

        float WaterFog = min(1, exp(-distance(ViewPos, ViewPos1) * 0.3 + 0.5));

        Color.rgb = WaterColor * 10;//mix(WaterColor * 10, vec3(1), WaterFog);

        float Caustics = get_water_caustics(PlayerPos);
        Color.rgb *= Caustics;
        
        // This is how water is detected later
        Color.a = 1 - WaterFog;
    } else {
        Color.rgb = srgb_linear(Color.rgb);
    }

    #ifdef RSM
        ShadowNormal.rg = encodeUnitVector(Normal) * 0.5 + 0.5;
    #endif
}
