#include "/lib/all_the_libs.glsl"

const ivec3 workGroups = ivec3(16, 8, 1);

layout(local_size_x = 8, local_size_y = 8) in;

void main() {
    vec2 FragCoord = gl_GlobalInvocationID.xy;

    float u = FragCoord.x / 128;
    float v = FragCoord.y / 64;

    float VangL = acosf(u * 2 - 1);
    float VangUp = v > 0.5 ? TAU*pow2(v)-TAU*v+PI : -TAU*pow2(v)+TAU*v;

    float Height = EarthRad + max(1, cameraPosition.y * 5);
    vec3 Origin = vec3(0, Height, 0);
    vec3 Dir = normalize(vec3(cos(VangL), -cos(VangUp), sin(VangL)));

    vec3 SunDir = normalize(vec3(1, view_player(sunPosN).y, 0));

    vec3 Scattering = calc_scattered_luminance(Origin, Dir, SunDir, 32, false, true).L;
    imageStore(atm_skyview, ivec2(FragCoord), vec4(Scattering, 0));
}