#include "/lib/all_the_libs.glsl"
#include "/generic/gbuffers.vsh"

void main() {
    init_generic();

    #ifdef WAVY_PLANTS
    vec3 WorldPos = view_player(DataOut.ViewPos);
    WorldPos += cameraPosition;
    vec3 WavePos = WorldPos / WAVE_SIZE + frameTimeCounter * WAVE_SPEED;
    WavePos = sin(WavePos);
    float Noise = WavePos.x * WavePos.y * WavePos.z;
    Noise *= WAVE_AMPLITUDE + rainStrength * 0.1;
    #ifdef WAVE_LEAVES
    if (DataOut.Material == MATERIAL_LEAVES) {
        WorldPos.x += Noise / 2;
        WorldPos.zy -= Noise / 2;
    }
    else
    #endif
    if (DataOut.Material == MATERIAL_SHORT_PLANT) {
        if (gl_MultiTexCoord0.t < mc_midTexCoord.t)
            WorldPos += Noise;
    }
    else if (DataOut.Material == MATERIAL_TALL_PLANT_LOWER) {
        if (gl_MultiTexCoord0.t < mc_midTexCoord.t)
            WorldPos += Noise / 2;
    }
    else if (DataOut.Material == MATERIAL_TALL_PLANT_UPPER) {
        if (gl_MultiTexCoord0.t > mc_midTexCoord.t)
            WorldPos += Noise / 2;
        else
            WorldPos += Noise;
    }

    WorldPos -= cameraPosition;
    WorldPos = mat3(gbufferModelView) * WorldPos;
    gl_Position = gl_ProjectionMatrix * vec4(WorldPos, 1);
    #endif
    
    // This needs to be redone since the original gl_Position is overwritten
    #if AA_MODE == 2
    gl_Position.xy += taaJitter * gl_Position.w;
    #endif
}
