#include "/lib/all_the_libs.glsl"
#include "/generic/post/taa.glsl"
in vec2 texcoord;

/* DRAWBUFFERS:048 */
layout(location = 0) out vec4 Color;
layout(location = 1) out vec4 TAAData;
layout(location = 2) out vec4 PrevDepth;

void main() {
    Color = texture(colortex0, texcoord);

    #ifndef DEBUG_DISABLE_TEMPORAL
    TAAData.rgb = TAA(Color.rgb, ivec2(gl_FragCoord.xy), texcoord);
    Color.rgb = TAAData.rgb;
    #endif

    PrevDepth.r = texture(depthtex1, texcoord).r;
}
