#include "/lib/all_the_libs.glsl"

layout(local_size_x = 4, local_size_y = 16) in;

ivec2 OFFSET = ivec2(256 * aspectRatio + 10, 0);
#include "/generic/post/bloom.glsl"

void main() {
    ivec2 GlobalPos = ivec2(gl_GlobalInvocationID.xy);

    vec2 SamplePos = GlobalPos * resolutionInv * 2;
    vec3 Color = read_bloom_downscale(SamplePos, false);
    write_bloom(GlobalPos + OFFSET, Color, true);
}
