/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.loaders;

import com.tom.cpm.shared.config.ResourceLoader;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.loaders.HttpResourceLoader;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;

public class PasteResourceLoader
extends HttpResourceLoader {
    private static boolean useFallback;

    @Override
    protected URL createURL(String path) throws IOException {
        return new URL((useFallback ? "https://cf-paste.tom5454.com" : "https://paste.tom5454.com") + "/raw/" + path);
    }

    @Override
    public byte[] loadResource(String path, ResourceLoader.ResourceEncoding enc, ModelDefinition def) throws IOException {
        URL url = this.createURL(path);
        try {
            return this.loadResource(url, enc, def);
        }
        catch (ConnectException | SocketTimeoutException e) {
            if (useFallback) {
                throw e;
            }
            useFallback = true;
            url = this.createURL(path);
            try {
                return this.loadResource(url, enc, def);
            }
            catch (SocketTimeoutException e2) {
                IOException ex = new IOException("No connection", e);
                ex.addSuppressed(e2);
                throw ex;
            }
        }
    }
}

