/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.tag;

import com.tom.cpl.block.Biome;
import com.tom.cpl.block.BlockState;
import com.tom.cpl.block.entity.EntityType;
import com.tom.cpl.item.Stack;
import com.tom.cpl.tag.IAllTags;
import com.tom.cpl.tag.TagManager;
import com.tom.cpl.util.TriConsumer;
import com.tom.cpm.shared.MinecraftClientAccess;

public class AllTagManagers
implements IAllTags {
    private final TagManager<BlockState> blockTags = new TagManager<BlockState>(BlockState.handler);
    private final TagManager<Stack> itemTags = new TagManager<Stack>(Stack.handler);
    private final TagManager<EntityType> entityTags = new TagManager<EntityType>(EntityType.handler);
    private final TagManager<Biome> biomeTags;

    public <E> AllTagManagers(E e, TriConsumer<E, TagManager<?>, String> loader) {
        this.biomeTags = new TagManager<Biome>(MinecraftClientAccess.get().getBiomeHandler());
        loader.accept(e, this.blockTags, "block");
        loader.accept(e, this.itemTags, "item");
        loader.accept(e, this.entityTags, "entity");
        loader.accept(e, this.biomeTags, "biome");
    }

    public AllTagManagers(AllTagManagers parent) {
        this.biomeTags = new TagManager<Biome>(parent.biomeTags);
        this.blockTags.setParent(parent.blockTags);
        this.itemTags.setParent(parent.itemTags);
        this.entityTags.setParent(parent.entityTags);
    }

    public AllTagManagers() {
        this.biomeTags = new TagManager<Biome>(MinecraftClientAccess.get().getBiomeHandler());
    }

    @Override
    public TagManager<BlockState> getBlockTags() {
        return this.blockTags;
    }

    @Override
    public TagManager<Stack> getItemTags() {
        return this.itemTags;
    }

    @Override
    public TagManager<EntityType> getEntityTags() {
        return this.entityTags;
    }

    @Override
    public TagManager<Biome> getBiomeTags() {
        return this.biomeTags;
    }
}

