/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.nbt;

import com.tom.cpl.nbt.NBTTag;
import com.tom.cpm.shared.io.IOHelper;
import java.io.IOException;

public class NBTTagShort
extends NBTTag.NBTPrimitive {
    private short data;

    public NBTTagShort() {
    }

    public NBTTagShort(short data) {
        this.data = data;
    }

    @Override
    public void write(IOHelper output) throws IOException {
        output.writeShort(this.data);
    }

    @Override
    public void read(IOHelper input) throws IOException {
        this.data = input.readShort();
    }

    @Override
    public byte getId() {
        return 2;
    }

    public String toString() {
        return this.data + "s";
    }

    @Override
    public NBTTag copy() {
        return new NBTTagShort(this.data);
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            NBTTagShort nbttagshort = (NBTTagShort)other;
            return this.data == nbttagshort.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.data;
    }

    @Override
    public long getLong() {
        return this.data;
    }

    @Override
    public int getInt() {
        return this.data;
    }

    @Override
    public short getShort() {
        return this.data;
    }

    @Override
    public byte getByte() {
        return (byte)(this.data & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.data;
    }

    @Override
    public float getFloat() {
        return this.data;
    }
}

