/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.entitydata;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wildfire.main.WildfireHelper;
import com.wildfire.main.config.Configuration;
import com.wildfire.main.entitydata.PlayerConfig;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import net.minecraft.class_2509;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public record BreastDataComponent(float breastSize, float cleavage, Vector3f offsets, boolean jacket, @Nullable class_9279 nbtComponent) {
    private static final String KEY = "WildfireGender";
    private static final Codec<BreastDataComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WildfireHelper.boundedFloat(Configuration.BUST_SIZE).optionalFieldOf("BreastSize", (Object)Float.valueOf(0.0f)).forGetter(BreastDataComponent::breastSize), (App)WildfireHelper.boundedFloat(Configuration.BREASTS_CLEAVAGE).optionalFieldOf("Cleavage", (Object)((Float)Configuration.BREASTS_CLEAVAGE.getDefault())).forGetter(BreastDataComponent::cleavage), (App)Codec.BOOL.optionalFieldOf("Jacket", (Object)true).forGetter(BreastDataComponent::jacket), (App)WildfireHelper.boundedFloat(Configuration.BREASTS_OFFSET_X).optionalFieldOf("XOffset", (Object)Float.valueOf(0.0f)).forGetter(component -> Float.valueOf(component.offsets.x)), (App)WildfireHelper.boundedFloat(Configuration.BREASTS_OFFSET_Y).optionalFieldOf("YOffset", (Object)Float.valueOf(0.0f)).forGetter(component -> Float.valueOf(component.offsets.y)), (App)WildfireHelper.boundedFloat(Configuration.BREASTS_OFFSET_Z).optionalFieldOf("ZOffset", (Object)Float.valueOf(0.0f)).forGetter(component -> Float.valueOf(component.offsets.y))).apply((Applicative)instance, (breastSize, cleavage, jacket, x, y, z) -> new BreastDataComponent(breastSize.floatValue(), cleavage.floatValue(), new Vector3f(x.floatValue(), y.floatValue(), z.floatValue()), (boolean)jacket, null)));
    private static final MapCodec<BreastDataComponent> MAP_CODEC = CODEC.fieldOf("WildfireGender");

    @Nullable
    public static BreastDataComponent fromPlayer(@NotNull class_1657 player, @NotNull PlayerConfig config) {
        if (!config.getGender().canHaveBreasts() || !config.showBreastsInArmor()) {
            return null;
        }
        return new BreastDataComponent(config.getBustSize(), config.getBreasts().getCleavage(), config.getBreasts().getOffsets(), player.method_7348(class_1664.field_7564), null);
    }

    @Nullable
    public static BreastDataComponent fromComponent(@Nullable class_9279 component) {
        if (component == null) {
            return null;
        }
        DataResult result = component.method_57446(MAP_CODEC);
        if (result.isError()) {
            return null;
        }
        return ((BreastDataComponent)result.getOrThrow()).withComponent(component);
    }

    public void write(class_7225.class_7874 lookup, class_1799 stack) {
        if (stack.method_7960()) {
            throw new IllegalArgumentException("The provided ItemStack must not be empty");
        }
        class_6903 op = lookup.method_57093((DynamicOps)class_2509.field_11560);
        DataResult result = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57447((DynamicOps)op, MAP_CODEC, (Object)this);
        if (result.isSuccess()) {
            stack.method_57379(class_9334.field_49628, (Object)((class_9279)result.getOrThrow()));
        }
    }

    public static void removeFromStack(class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        class_9279 component = (class_9279)stack.method_58694(class_9334.field_49628);
        if (component != null && component.method_57450(KEY)) {
            class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)stack, nbt -> nbt.method_10551(KEY));
        }
    }

    private BreastDataComponent withComponent(class_9279 component) {
        return new BreastDataComponent(this.breastSize, this.cleavage, this.offsets, this.jacket, component);
    }
}

