/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.wildfire.api.IGenderArmor;
import com.wildfire.events.ArmorStandInteractEvents;
import com.wildfire.events.ArmorStatsTooltipEvent;
import com.wildfire.events.EntityHurtSoundEvent;
import com.wildfire.events.EntityTickEvent;
import com.wildfire.events.PlayerNametagRenderEvent;
import com.wildfire.gui.SyncedPlayerList;
import com.wildfire.gui.screen.WardrobeBrowserScreen;
import com.wildfire.gui.screen.WildfireFirstTimeSetupScreen;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireGenderClient;
import com.wildfire.main.WildfireHelper;
import com.wildfire.main.cloud.CloudSync;
import com.wildfire.main.config.GlobalConfig;
import com.wildfire.main.entitydata.BreastDataComponent;
import com.wildfire.main.entitydata.EntityConfig;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.main.networking.ServerboundSyncPacket;
import com.wildfire.main.networking.WildfireSync;
import com.wildfire.render.GenderArmorLayer;
import com.wildfire.render.GenderLayer;
import com.wildfire.render.HolidayFeaturesRenderer;
import com.wildfire.render.RenderStateEntityCapture;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_10192;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4050;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_634;
import net.minecraft.class_7225;
import net.minecraft.class_877;
import net.minecraft.class_922;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.class_9779;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class WildfireEventHandler {
    private static final class_304 CONFIG_KEYBIND;
    private static final class_304 TOGGLE_KEYBIND;
    private static int timer;

    private WildfireEventHandler() {
        throw new UnsupportedOperationException();
    }

    public static class_304 getConfigKeybind() {
        return CONFIG_KEYBIND;
    }

    public static void registerCommonEvents() {
        EntityTrackingEvents.START_TRACKING.register(WildfireEventHandler::onBeginTracking);
        ServerPlayConnectionEvents.DISCONNECT.register(WildfireEventHandler::playerDisconnected);
        ArmorStandInteractEvents.EQUIP.register(WildfireEventHandler::onEquipArmorStand);
        ArmorStandInteractEvents.REMOVE.register(BreastDataComponent::removeFromStack);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClientEvents() {
        ClientEntityEvents.ENTITY_UNLOAD.register(WildfireEventHandler::onEntityUnload);
        ClientTickEvents.END_CLIENT_TICK.register(WildfireEventHandler::onClientTick);
        ClientPlayConnectionEvents.DISCONNECT.register(WildfireEventHandler::clientDisconnect);
        ClientPlayConnectionEvents.JOIN.register(WildfireEventHandler::clientJoin);
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register(WildfireEventHandler::registerRenderLayers);
        HudElementRegistry.attachElementAfter((class_2960)VanillaHudElements.MISC_OVERLAYS, (class_2960)class_2960.method_60655((String)"wildfire_gender", (String)"player_list"), WildfireEventHandler::renderHud);
        ArmorStatsTooltipEvent.EVENT.register(WildfireEventHandler::renderTooltip);
        EntityHurtSoundEvent.EVENT.register(WildfireEventHandler::onEntityHurt);
        EntityTickEvent.EVENT.register(WildfireEventHandler::onEntityTick);
        PlayerNametagRenderEvent.EVENT.register(WildfireEventHandler::onPlayerNametag);
    }

    @Environment(value=EnvType.CLIENT)
    private static void onPlayerNametag(class_10055 state, class_4587 matrixStack, class_4597 vertexConsumerProvider, Consumer<class_2561> renderHelper) {
        class_1657 p;
        class_1657 player;
        class_1309 class_13092 = ((RenderStateEntityCapture)state).getEntity();
        class_1657 class_16572 = player = class_13092 instanceof class_1657 ? (p = (class_1657)class_13092) : null;
        if (player == null) {
            return;
        }
        class_2561 nametag = WildfireGenderClient.getNametag(player.method_5667());
        if (nametag == null) {
            return;
        }
        matrixStack.method_22903();
        float translationAmt = switch (player.method_18376()) {
            case class_4050.field_18081 -> 0.8f;
            case class_4050.field_18078 -> 0.125f;
            case class_4050.field_18079, class_4050.field_18077 -> 0.3f;
            case class_4050.field_40118 -> 0.275f;
            default -> 0.95f;
        };
        matrixStack.method_46416(0.0f, translationAmt, 0.0f);
        matrixStack.method_22905(0.5f, 0.5f, 0.5f);
        renderHelper.accept(nametag);
        matrixStack.method_22909();
        matrixStack.method_46416(0.0f, 0.0618125f, 0.0f);
    }

    @Environment(value=EnvType.CLIENT)
    private static void renderTooltip(class_1799 item, Consumer<class_2561> tooltipAppender, @Nullable class_1657 player) {
        if (player == null || !GlobalConfig.INSTANCE.get(GlobalConfig.ARMOR_STAT).booleanValue()) {
            return;
        }
        PlayerConfig playerConfig = WildfireGender.getPlayerById(player.method_5667());
        if (playerConfig == null || !playerConfig.getGender().canHaveBreasts()) {
            return;
        }
        class_10192 equippableComponent = (class_10192)item.method_58694(class_9334.field_54196);
        if (equippableComponent != null && equippableComponent.comp_3174() == class_1304.field_6174) {
            IGenderArmor config = WildfireHelper.getArmorConfig(item);
            if (!config.coversBreasts() || config.physicsResistance() == 0.0f) {
                return;
            }
            String formatted = class_9285.field_49329.format(config.physicsResistance());
            tooltipAppender.accept((class_2561)class_2561.method_43469((String)"wildfire_gender.armor.tooltip", (Object[])new Object[]{formatted}).method_27692(class_124.field_1076));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void renderHud(class_332 context, class_9779 tickCounter) {
        class_327 textRenderer = Objects.requireNonNull(class_310.method_1551().field_1772, "textRenderer");
        if (class_310.method_1551().field_1755 instanceof WardrobeBrowserScreen) {
            return;
        }
        if (GlobalConfig.INSTANCE.get(GlobalConfig.ALWAYS_SHOW_LIST).isVisible()) {
            SyncedPlayerList.drawSyncedPlayers(context, textRenderer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void registerRenderLayers(class_1299<? extends class_1309> entityType, class_922<?, ?, ?> entityRenderer, LivingEntityFeatureRendererRegistrationCallback.RegistrationHelper registrationHelper, class_5617.class_5618 context) {
        if (entityRenderer instanceof class_1007) {
            class_1007 playerRenderer = (class_1007)entityRenderer;
            registrationHelper.register(new GenderLayer(playerRenderer));
            registrationHelper.register(new GenderArmorLayer(playerRenderer, context.method_64071(), context.method_64072()));
            registrationHelper.register((class_3887)new HolidayFeaturesRenderer((class_3883<class_10055, class_591>)playerRenderer));
        } else if (entityRenderer instanceof class_877) {
            class_877 armorStandRenderer = (class_877)entityRenderer;
            registrationHelper.register(new GenderArmorLayer(armorStandRenderer, context.method_64071(), context.method_64072()));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void onEntityUnload(class_1297 entity, class_1937 world) {
        EntityConfig.CACHE.invalidate((Object)entity.method_5667());
    }

    @Environment(value=EnvType.CLIENT)
    private static void onClientTick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        PlayerConfig clientConfig = WildfireGender.getPlayerById(client.field_1724.method_5667());
        if (ServerboundSyncPacket.canSend() && ++timer % 5 == 0 && clientConfig != null) {
            WildfireSync.sendToServer(clientConfig);
        }
        if (timer % 40 == 0) {
            CloudSync.sendNextQueueBatch();
            if (clientConfig != null) {
                clientConfig.attemptCloudSync();
            }
        }
        if (TOGGLE_KEYBIND.method_1436() && client.field_1755 == null) {
            GlobalConfig.RENDER_BREASTS ^= true;
        }
        if (CONFIG_KEYBIND.method_1436() && client.field_1755 == null) {
            if (GlobalConfig.INSTANCE.get(GlobalConfig.FIRST_TIME_LOAD).booleanValue() && CloudSync.isAvailable()) {
                client.method_1507((class_437)new WildfireFirstTimeSetupScreen(null, client.field_1724.method_5667()));
            } else {
                client.method_1507((class_437)new WardrobeBrowserScreen(null, client.field_1724.method_5667()));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void clientDisconnect(class_634 networkHandler, class_310 client) {
        WildfireGender.CACHE.invalidateAll();
        EntityConfig.CACHE.invalidateAll();
    }

    @Environment(value=EnvType.CLIENT)
    private static void clientJoin(class_634 var1, PacketSender var2, class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
    }

    private static void playerDisconnected(class_3244 handler, MinecraftServer server) {
        WildfireGender.CACHE.invalidate((Object)handler.method_32311().method_5667());
    }

    private static void onBeginTracking(class_1297 tracked, class_3222 syncTo) {
        if (tracked instanceof class_1657) {
            class_1657 toSync = (class_1657)tracked;
            PlayerConfig genderToSync = WildfireGender.getPlayerById(toSync.method_5667());
            if (genderToSync == null) {
                return;
            }
            WildfireSync.sendToClient(syncTo, genderToSync);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void onEntityHurt(class_1309 entity, class_1282 damageSource) {
        class_1657 player;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (!(entity instanceof class_1657) || !(player = (class_1657)entity).method_37908().method_8608()) {
            return;
        }
        PlayerConfig genderPlayer = WildfireGender.getPlayerById(player.method_5667());
        if (genderPlayer == null || !genderPlayer.hasHurtSounds()) {
            return;
        }
        class_3414 hurtSound = genderPlayer.getGender().getHurtSound();
        if (hurtSound != null) {
            float pitchVariation = (player.method_59922().method_43057() - player.method_59922().method_43057()) * 0.2f;
            player.method_5783(hurtSound, 1.0f, pitchVariation + genderPlayer.getVoicePitch());
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void onEntityTick(class_1309 entity) {
        if (EntityConfig.isSupportedEntity(entity)) {
            EntityConfig cfg = EntityConfig.getEntity(entity);
            if (entity instanceof class_1531) {
                cfg.readFromStack(entity.method_6118(class_1304.field_6174));
            }
            cfg.tickBreastPhysics(entity);
        }
    }

    private static void onEquipArmorStand(class_1657 player, class_1799 item) {
        PlayerConfig playerConfig = WildfireGender.getPlayerById(player.method_5667());
        if (playerConfig == null) {
            BreastDataComponent.removeFromStack(item);
            return;
        }
        BreastDataComponent component = BreastDataComponent.fromPlayer(player, playerConfig);
        if (component != null) {
            component.write((class_7225.class_7874)player.method_37908().method_30349(), item);
        }
    }

    static {
        timer = 0;
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            CONFIG_KEYBIND = (class_304)class_156.method_656(() -> {
                class_304 keybind = new class_304("key.wildfire_gender.gender_menu", 72, "category.wildfire_gender.generic");
                KeyBindingHelper.registerKeyBinding((class_304)keybind);
                return keybind;
            });
            TOGGLE_KEYBIND = (class_304)class_156.method_656(() -> {
                class_304 keybind = new class_304("key.wildfire_gender.toggle", -1, "category.wildfire_gender.generic");
                KeyBindingHelper.registerKeyBinding((class_304)keybind);
                return keybind;
            });
        } else {
            CONFIG_KEYBIND = null;
            TOGGLE_KEYBIND = null;
        }
    }
}

