/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import java.util.List;
import java.util.function.Function;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;
import me.pepperbell.continuity.client.util.TextureUtil;
import net.minecraft.class_1058;
import net.minecraft.class_4730;

public abstract class AbstractQuadProcessorFactory<T extends BaseCtmProperties>
implements QuadProcessor.Factory<T> {
    @Override
    public QuadProcessor createProcessor(T properties, Function<class_4730, class_1058> textureGetter) {
        int i;
        int provided;
        int textureAmount = this.getTextureAmount(properties);
        List<class_4730> spriteIds = ((BaseCtmProperties)properties).getSpriteIds();
        int max = provided = spriteIds.size();
        if (provided > textureAmount) {
            ContinuityClient.LOGGER.warn("Method '" + ((BaseCtmProperties)properties).getMethod() + "' requires " + textureAmount + " tiles but " + provided + " were provided in file '" + String.valueOf(((BaseCtmProperties)properties).getResourceId()) + "' in pack '" + ((BaseCtmProperties)properties).getPackId() + "'");
            max = textureAmount;
        }
        class_1058[] sprites = new class_1058[textureAmount];
        class_1058 missingSprite = textureGetter.apply(TextureUtil.MISSING_SPRITE_ID);
        boolean supportsNullSprites = this.supportsNullSprites(properties);
        for (i = 0; i < max; ++i) {
            class_4730 spriteId = spriteIds.get(i);
            class_1058 sprite = spriteId.equals((Object)BaseCtmProperties.SPECIAL_SKIP_SPRITE_ID) ? missingSprite : (spriteId.equals((Object)BaseCtmProperties.SPECIAL_DEFAULT_SPRITE_ID) ? (supportsNullSprites ? null : missingSprite) : textureGetter.apply(spriteId));
            sprites[i] = sprite;
        }
        if (provided < textureAmount) {
            ContinuityClient.LOGGER.error("Method '" + ((BaseCtmProperties)properties).getMethod() + "' requires " + textureAmount + " tiles but only " + provided + " were provided in file '" + String.valueOf(((BaseCtmProperties)properties).getResourceId()) + "' in pack '" + ((BaseCtmProperties)properties).getPackId() + "'");
            for (i = provided; i < textureAmount; ++i) {
                sprites[i] = missingSprite;
            }
        }
        return this.createProcessor(properties, sprites);
    }

    public abstract QuadProcessor createProcessor(T var1, class_1058[] var2);

    public abstract int getTextureAmount(T var1);

    public boolean supportsNullSprites(T properties) {
        return true;
    }
}

