/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.reload;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.estecka.variantscit.VariantLibrary;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.modulebakers.IBakedModule;
import fr.estecka.variantscit.reload.EModuleContext;
import fr.estecka.variantscit.reload.ModuleDefinition;
import fr.estecka.variantscit.reload.UnbakedModule;
import fr.estecka.variantscit.reload.VariantAggregator;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public final class ModuleLoader {
    public static Result ReloadModules(class_3300 manager) {
        class_2960 moduleId;
        ArrayList<MetaModule> metamodules = new ArrayList<MetaModule>();
        HashMap<class_2960, class_3298> resources = new HashMap<class_2960, class_3298>();
        HashMap<class_2960, ModuleDefinition> definitions = new HashMap<class_2960, ModuleDefinition>();
        resources.putAll(manager.method_14488("variant-cits/item", id -> id.method_12832().endsWith(".json")));
        ModuleLoader.ObsoletePathWarning(resources);
        resources.putAll(manager.method_14488("variants-cit/item", id -> id.method_12832().endsWith(".json")));
        for (Map.Entry entry : resources.entrySet()) {
            moduleId = ModuleLoader.ModuleIdFromResourceId((class_2960)entry.getKey());
            DataResult<ModuleDefinition> optDefinition = ModuleLoader.DefinitionFromResource((class_3298)entry.getValue());
            if (optDefinition.isError()) {
                VariantsCitMod.LOGGER.error("Error in VCIT module {}: {}", moduleId, ((DataResult.Error)optDefinition.error().get()).message());
                continue;
            }
            ModuleDefinition definition = (ModuleDefinition)optDefinition.getOrThrow();
            if (definition.contexts().isEmpty()) {
                VariantsCitMod.LOGGER.warn("Skipped VCIT module with no context: {}", moduleId);
                continue;
            }
            if (ModuleLoader.ItemsFromModule(moduleId, definition).isEmpty()) {
                VariantsCitMod.LOGGER.warn("Skipped VCIT module with no valid item: {}", moduleId);
                continue;
            }
            if (definition.modelPrefix().isEmpty()) {
                VariantsCitMod.LOGGER.error("VCIT module `{}` has an empty model prefix. This can lead to unexpected behaviours and performance loss.", moduleId);
            }
            definitions.put(moduleId, definition);
        }
        Result result = new Result(definitions);
        result.variantAggregator.GatherAll(manager);
        for (Map.Entry entry : definitions.entrySet()) {
            moduleId = (class_2960)entry.getKey();
            ModuleDefinition definition = (ModuleDefinition)entry.getValue();
            Set<class_1792> targets = ModuleLoader.ItemsFromModule(moduleId, definition);
            metamodules.add(new MetaModule(moduleId, definition.priority(), targets, result.variantAggregator.GetLibrary(EModuleContext.ITEM_MODEL, definition), result.variantAggregator.GetLibrary(EModuleContext.EQUIPPABLE, definition), definition.parameters()));
        }
        metamodules.sort((a, b) -> -Integer.compare(a.priority(), b.priority()));
        if (!result.variantAggregator.conflictingModelPrefixes.isEmpty()) {
            Object message = "Some modules with identical model prefixes have conflicting model parents, it is undefined which parent will be used. The following prefixes are involved: ";
            for (String prefix : result.variantAggregator.conflictingModelPrefixes) {
                message = (String)message + "\n - " + prefix;
            }
            VariantsCitMod.LOGGER.error((String)message, new Object[0]);
        }
        ModuleLoader.BakeModules(result, metamodules);
        return result;
    }

    private static void ObsoletePathWarning(Map<class_2960, class_3298> resources) {
        if (!resources.isEmpty()) {
            Object names = "";
            for (class_2960 id : resources.keySet()) {
                names = (String)names + " ";
                names = (String)names + ModuleLoader.ModuleIdFromResourceId(id).toString();
            }
            VariantsCitMod.LOGGER.warn("Some VCIT modules are using the old mispelled directory `variant-cits`, those should be moved to `variants-cit` instead:{}", names);
        }
    }

    private static DataResult<ModuleDefinition> DefinitionFromResource(class_3298 resource) {
        JsonObject json;
        try {
            json = class_3518.method_15255((Reader)resource.method_43039());
        }
        catch (JsonParseException | IOException e) {
            return DataResult.error(((Exception)e)::toString);
        }
        return ModuleDefinition.CODEC.decoder().decode((DynamicOps)JsonOps.INSTANCE, (Object)json).map(Pair::getFirst);
    }

    private static Set<class_1792> ItemsFromModule(class_2960 moduleId, ModuleDefinition module) {
        return module.targets().map(ModuleLoader::ItemsFromTarget).orElseGet(() -> ModuleLoader.ItemsFromModuleId(moduleId));
    }

    private static Set<class_1792> ItemsFromTarget(List<class_2960> targets) {
        HashSet<class_1792> result = new HashSet<class_1792>();
        targets.stream().map(id -> class_7923.field_41178.method_10223(id)).filter(Optional::isPresent).map(opt -> (class_1792)((class_6880.class_6883)opt.get()).comp_349()).forEach(result::add);
        return result;
    }

    private static Set<class_1792> ItemsFromModuleId(class_2960 moduleId) {
        class_2960 itemId = ModuleLoader.ItemIdFromModuleId(moduleId);
        if (class_7923.field_41178.method_10250(itemId)) {
            return Set.of((class_1792)((class_6880.class_6883)class_7923.field_41178.method_10223(itemId).get()).comp_349());
        }
        return Set.of();
    }

    private static class_2960 ItemIdFromModuleId(class_2960 resource) {
        String path = resource.method_12832();
        path = path.substring("item/".length());
        return class_2960.method_60655((String)resource.method_12836(), (String)path);
    }

    private static class_2960 ModuleIdFromResourceId(class_2960 resource) {
        String path = resource.method_12832();
        path = path.substring("variant-cits/".length(), path.length() - ".json".length());
        return class_2960.method_60655((String)resource.method_12836(), (String)path);
    }

    public static void BakeModules(Result result, List<MetaModule> modules) {
        HashMap<class_1792, List<IBakedModule>> itemModules = new HashMap<class_1792, List<IBakedModule>>();
        HashMap<class_1792, List<IBakedModule>> equipModules = new HashMap<class_1792, List<IBakedModule>>();
        for (MetaModule meta : modules) {
            VariantsCitMod.LOGGER.PushLabel(meta.id);
            if (meta.itemLibrary().isPresent()) {
                ModuleLoader.BakeModuleContext("item_model", meta, meta.itemLibrary().get(), itemModules);
            }
            if (meta.equipLibrary().isPresent()) {
                ModuleLoader.BakeModuleContext("equippable", meta, meta.equipLibrary().get(), equipModules);
            }
            VariantsCitMod.LOGGER.PopLabel();
        }
        ModuleLoader.BakeItem(result.itemModules, itemModules);
        ModuleLoader.BakeItem(result.equipModules, equipModules);
    }

    private static void BakeModuleContext(String contextName, MetaModule meta, VariantLibrary lib, Map<class_1792, List<IBakedModule>> output) {
        if (lib.isEmpty()) {
            VariantsCitMod.LOGGER.Unlabelled().warn("Empty {} VCIT module {}", (Object)contextName, (Object)meta.id());
        } else {
            VariantsCitMod.LOGGER.Unlabelled().info("Found {} {} variants for VCIT module {}", new Object[]{lib.GetVariantCount(), contextName, meta.id()});
        }
        for (class_1792 itemType : meta.targets()) {
            output.computeIfAbsent(itemType, __ -> new ArrayList()).add(meta.parameters.Bake(lib));
        }
    }

    private static void BakeItem(Map<class_1792, IBakedModule> result, Map<class_1792, List<IBakedModule>> moduleListPerItem) {
        for (Map.Entry<class_1792, List<IBakedModule>> entry : moduleListPerItem.entrySet()) {
            result.put(entry.getKey(), IBakedModule.OfList(entry.getValue()));
        }
    }

    public static class Result {
        public final Map<class_1792, IBakedModule> itemModules = new HashMap<class_1792, IBakedModule>();
        public final Map<class_1792, IBakedModule> equipModules = new HashMap<class_1792, IBakedModule>();
        public final VariantAggregator variantAggregator;

        private Result(Map<class_2960, ModuleDefinition> modules) {
            this.variantAggregator = new VariantAggregator(modules);
        }
    }

    public record MetaModule(class_2960 id, int priority, Set<class_1792> targets, Optional<VariantLibrary> itemLibrary, Optional<VariantLibrary> equipLibrary, UnbakedModule<?> parameters) {
    }
}

