/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import su.plo.voice.proto.data.player.VoicePlayerInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;

public final class PlayerListPacket
implements Packet<ClientPacketTcpHandler> {
    private List<VoicePlayerInfo> players;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        int size = in.readInt();
        this.players = new ArrayList<VoicePlayerInfo>(size);
        for (int i = 0; i < size; ++i) {
            VoicePlayerInfo player = new VoicePlayerInfo();
            player.deserialize(in);
            this.players.add(player);
        }
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        Preconditions.checkNotNull(this.players, (Object)"players");
        out.writeInt(this.players.size());
        for (VoicePlayerInfo player : this.players) {
            player.serialize(out);
        }
    }

    @Override
    public void handle(ClientPacketTcpHandler handler) {
        handler.handle(this);
    }

    public PlayerListPacket(List<VoicePlayerInfo> players) {
        this.players = players;
    }

    public PlayerListPacket() {
    }

    public String toString() {
        return "PlayerListPacket(players=" + this.getPlayers() + ")";
    }

    public List<VoicePlayerInfo> getPlayers() {
        return this.players;
    }
}

