/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.interndep.flowsched.scheduler;

import ca.spottedleaf.starlight.interndep.flowsched.scheduler.ObjectFactory;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.StatusAdvancingScheduler;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class DaemonizedStatusAdvancingScheduler<K, V, Ctx, UserData>
extends StatusAdvancingScheduler<K, V, Ctx, UserData> {
    protected final Thread thread;
    private final Object notifyMonitor = new Object();
    private final AtomicInteger taskSize = new AtomicInteger();
    private final Queue<Runnable> taskQueue;
    private final Executor executor;
    private final Scheduler scheduler;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    protected DaemonizedStatusAdvancingScheduler(ThreadFactory threadFactory) {
        this(threadFactory, new ObjectFactory.DefaultObjectFactory());
    }

    protected DaemonizedStatusAdvancingScheduler(ThreadFactory threadFactory, ObjectFactory objectFactory) {
        super(objectFactory);
        this.thread = threadFactory.newThread(this::mainLoop);
        this.taskQueue = objectFactory.newMPSCQueue();
        this.executor = e -> {
            boolean needWakeup = this.taskSize.getAndIncrement() == 0;
            this.taskQueue.add(e);
            if (needWakeup) {
                this.wakeUp();
            }
        };
        this.scheduler = Schedulers.from((Executor)this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() {
        while (true) {
            if (this.pollTasks()) {
                continue;
            }
            if (this.shutdown.get()) {
                return;
            }
            Object object = this.notifyMonitor;
            synchronized (object) {
                if (this.continueProcessWork() || this.shutdown.get()) {
                    continue;
                }
                try {
                    this.notifyMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean pollTasks() {
        Runnable runnable;
        boolean hasWork = false;
        while ((runnable = this.taskQueue.poll()) != null) {
            this.taskSize.decrementAndGet();
            hasWork = true;
            try {
                runnable.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return hasWork |= this.tick();
    }

    public void waitTickSync() {
        if (Thread.currentThread() == this.thread) {
            throw new IllegalStateException("Cannot wait sync on scheduler thread");
        }
        CompletableFuture future = new CompletableFuture();
        this.getExecutor().execute(() -> future.complete(null));
        future.join();
    }

    @Override
    protected final Executor getExecutor() {
        return this.executor;
    }

    @Override
    protected final Scheduler getSchedulerBackedByExecutor() {
        return this.scheduler;
    }

    @Override
    protected Executor getBackgroundExecutor() {
        return this.getExecutor();
    }

    @Override
    protected Scheduler getSchedulerBackedByBackgroundExecutor() {
        return this.getSchedulerBackedByExecutor();
    }

    @Override
    protected boolean hasPendingUpdates() {
        return !this.taskQueue.isEmpty() || super.hasPendingUpdates();
    }

    @Override
    protected boolean continueProcessWork() {
        return this.taskSize.get() != 0 || super.continueProcessWork();
    }

    @Override
    protected void markDirty(K key) {
        super.markDirty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void wakeUp() {
        Object object = this.notifyMonitor;
        synchronized (object) {
            this.notifyMonitor.notify();
        }
    }

    public void shutdown() {
        this.shutdown.set(true);
        this.wakeUp();
    }
}

