/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.interndep.flowsched.scheduler;

import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class CancellationSignaller {
    public static final CancellationSignaller COMPLETED;
    private final ReferenceList<Consumer<Throwable>> onComplete = new ReferenceArrayList();
    private final Consumer<CancellationSignaller> cancel;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicReference<Optional<Throwable>> finished = new AtomicReference<Object>(null);

    public CancellationSignaller(Consumer<CancellationSignaller> cancel) {
        this.cancel = Objects.requireNonNull(cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fireComplete(Throwable throwable) {
        if (!this.finished.compareAndSet(null, Optional.ofNullable(throwable))) return;
        Consumer[] consumerArray = this;
        synchronized (this) {
            Consumer[] consumers = (Consumer[])this.onComplete.toArray(Consumer[]::new);
            this.onComplete.clear();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Consumer consumer : consumers) {
                try {
                    consumer.accept(throwable);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Consumer<Throwable> callback) {
        if (this.finished.get() != null) {
            callback.accept(this.finished.get().orElse(null));
            return;
        }
        CancellationSignaller cancellationSignaller = this;
        synchronized (cancellationSignaller) {
            if (this.finished.get() != null) {
                callback.accept(this.finished.get().orElse(null));
                return;
            }
            this.onComplete.add(callback);
        }
    }

    public void cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            this.cancel.accept(this);
        }
    }

    static {
        CancellationSignaller signaller = new CancellationSignaller(unused -> {});
        signaller.finished.set(Optional.empty());
        signaller.cancelled.set(true);
        COMPLETED = signaller;
    }
}

