/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.imaginebook;

import io.github.jumperonjava.imaginebook.image.ImageData;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageSerializer {
    public static byte[] serializeImageMetadata(List<ImageData> imagesDefinition) {
        ByteBuffer buf = ByteBuffer.allocate(1000);
        buf.putShort((short)14);
        buf.put((byte)imagesDefinition.size());
        for (ImageData image : imagesDefinition) {
            byte[] url = image.getUrl().getBytes(StandardCharsets.UTF_8);
            buf.put((byte)url.length);
            buf.put(url, 0, url.length);
            buf.putShort((short)image.x);
            buf.putShort((short)image.y);
            buf.putFloat(image.widthFraction);
            buf.putFloat(image.heightFraction);
            buf.putShort((short)((image.rotation - 180.0f) / 180.0f * 32767.0f));
        }
        int len = buf.position();
        byte[] shortBuf = new byte[len + 1];
        for (int i = 0; i < len; ++i) {
            shortBuf[i] = buf.get(i);
        }
        return shortBuf;
    }

    public static List<ImageData> deserializeImageMetadata(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        int format = buf.getShort();
        ArrayList<ImageData> images = new ArrayList<ImageData>();
        int amount = buf.get();
        for (int i = 0; i < amount; ++i) {
            ImageData image = new ImageData();
            images.add(image);
            int urlsize = buf.get() & 0xFF;
            byte[] urlbytes = new byte[urlsize];
            buf.get(urlbytes);
            image.setUrl(new String(urlbytes, StandardCharsets.UTF_8));
            int usedBytes = 0;
            image.x = buf.getShort();
            usedBytes += 2;
            image.y = buf.getShort();
            usedBytes += 2;
            image.widthFraction = buf.getFloat();
            usedBytes += 4;
            image.heightFraction = buf.getFloat();
            usedBytes += 4;
            image.rotation = (float)buf.getShort() / 32767.0f * 180.0f + 180.0f;
            usedBytes += 2;
            while (format > usedBytes) {
                buf.get();
                ++usedBytes;
            }
        }
        return images;
    }

    public static List<ImageData> parseSafeModeImages(String page) {
        Pattern pattern = Pattern.compile("\\[[^,]*?(,[+-]?\\d+(\\.\\d+)?){2,5}\\]");
        Matcher matcher = pattern.matcher(page);
        ArrayList<ImageData> images = new ArrayList<ImageData>();
        while (matcher.find()) {
            String str = matcher.group();
            if (str == null) continue;
            ImageData data = new ImageData();
            try {
                String[] elements = (String[])Arrays.stream(str.replace("[", "").replace("]", "").split("[,]")).toArray(String[]::new);
                data.setUrl(elements[0]);
                images.add(data);
                String[] numbers = (String[])Arrays.stream(elements).skip(1L).flatMap(element -> Arrays.stream(element.split(","))).flatMap(s -> Arrays.stream(s.split("(?=[+-])"))).toList().toArray(String[]::new);
                if (numbers.length >= 2) {
                    data.x = Float.parseFloat(numbers[0]);
                    data.y = Float.parseFloat(numbers[1]);
                }
                if (numbers.length == 3) {
                    data.widthFraction = Float.parseFloat(numbers[2]) / 100.0f;
                    data.heightFraction = Float.parseFloat(numbers[2]) / 100.0f;
                }
                if (numbers.length == 4) {
                    data.widthFraction = Float.parseFloat(numbers[2]) / 100.0f;
                    data.heightFraction = Float.parseFloat(numbers[3]) / 100.0f;
                }
                if (numbers.length != 5) continue;
                data.widthFraction = Float.parseFloat(numbers[2]) / 100.0f;
                data.heightFraction = Float.parseFloat(numbers[3]) / 100.0f;
                data.rotation = Float.parseFloat(numbers[4]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return images;
    }
}

