/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.net.packet;

import io.netty.buffer.ByteBuf;
import ru.dimaskama.webcam.net.packet.Packet;
import ru.dimaskama.webcam.net.packet.PacketType;

public record PermissionsS2CPacket(boolean broadcast, boolean view) implements Packet
{
    private static final int BROADCAST_FLAG = 1;
    private static final int VIEW_FLAG = 2;

    public static PermissionsS2CPacket decode(ByteBuf buf) {
        int flags = buf.readByte() & 0xFF;
        return new PermissionsS2CPacket((flags & 1) != 0, (flags & 2) != 0);
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        int flags = (this.broadcast ? 1 : 0) | (this.view ? 2 : 0);
        buf.writeByte(flags);
    }

    public PacketType<PermissionsS2CPacket> getType() {
        return PacketType.PERMISSIONS_S2C;
    }

    @Override
    public int getEstimatedSize() {
        return 1;
    }
}

