/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.net.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import ru.dimaskama.webcam.net.packet.Packet;
import ru.dimaskama.webcam.net.packet.PacketType;

public record AuthPacket(UUID playerUuid, UUID secret) implements Packet
{
    public AuthPacket(ByteBuf buf) {
        this(new UUID(buf.readLong(), buf.readLong()), new UUID(buf.readLong(), buf.readLong()));
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        buf.writeLong(this.playerUuid.getMostSignificantBits()).writeLong(this.playerUuid.getLeastSignificantBits()).writeLong(this.secret.getMostSignificantBits()).writeLong(this.secret.getLeastSignificantBits());
    }

    @Override
    public int getEstimatedSize() {
        return 32;
    }

    public PacketType<AuthPacket> getType() {
        return PacketType.AUTH;
    }
}

