/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.message;

import java.util.UUID;
import ru.dimaskama.webcam.Webcam;
import ru.dimaskama.webcam.WebcamService;
import ru.dimaskama.webcam.message.Channel;
import ru.dimaskama.webcam.message.Message;
import ru.dimaskama.webcam.message.SecretMessage;
import ru.dimaskama.webcam.message.SecretRequestMessage;
import ru.dimaskama.webcam.server.WebcamServer;

public class ServerMessaging {
    public static void init() {
        WebcamService service = Webcam.getService();
        service.registerChannel(Channel.SECRET_REQUEST, ServerMessaging::onSecretRequest);
        service.registerChannel(Channel.SECRET, null);
    }

    private static void onSecretRequest(UUID playerUuid, String playerName, SecretRequestMessage message) {
        WebcamServer server = WebcamServer.getInstance();
        if (server != null) {
            if (Webcam.isClientVersionCompatible(message.version())) {
                Webcam.getLogger().info("Sending secret to " + playerName);
                Webcam.getService().sendToPlayer(playerUuid, new SecretMessage(server.getOrCreatePlayerState(playerUuid, playerName).getSecret(), server.getPort(), server.getKeepAlivePeriod(), server.getHost()));
            } else {
                Webcam.getLogger().info("Client protocol version is incompatible. Not replying on secret request");
                String msg = Webcam.getServerConfig().getData().messages().incompatibleModVersion();
                if (!msg.isBlank()) {
                    Webcam.getService().sendSystemMessage(playerUuid, String.format(msg, message.version(), Webcam.getVersion()));
                }
            }
        }
    }

    @FunctionalInterface
    public static interface ServerHandler<T extends Message> {
        public void handle(UUID var1, String var2, T var3);
    }
}

