/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.message;

import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import ru.dimaskama.webcam.message.Message;
import ru.dimaskama.webcam.message.SecretMessage;
import ru.dimaskama.webcam.message.SecretRequestMessage;

public class Channel<T extends Message> {
    public static final Channel<SecretRequestMessage> SECRET_REQUEST = new Channel<SecretRequestMessage>("webcam:secret_request", SecretRequestMessage::new);
    public static final Channel<SecretMessage> SECRET = new Channel<SecretMessage>("webcam:secret", SecretMessage::new);
    private final String id;
    private final Function<ByteBuf, T> decoder;

    public Channel(String id, Function<ByteBuf, T> decoder) {
        this.id = id;
        this.decoder = decoder;
    }

    public String getId() {
        return this.id;
    }

    public T decode(ByteBuf buf) {
        return (T)((Message)this.decoder.apply(buf));
    }
}

