/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.message;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public class BufUtils {
    public static int readVarInt(ByteBuf buf) {
        byte b;
        int i = 0;
        int j = 0;
        do {
            b = buf.readByte();
            i |= (b & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b & 0x80) == 128);
        return i;
    }

    public static void writeVarInt(ByteBuf buf, int i) {
        while ((i & 0xFFFFFF80) != 0) {
            buf.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        buf.writeByte(i);
    }

    public static String readUtf8(ByteBuf buf) {
        int size = BufUtils.readVarInt(buf);
        byte[] strBytes = new byte[size];
        buf.readBytes(strBytes);
        return new String(strBytes, StandardCharsets.UTF_8);
    }

    public static void writeUtf8(ByteBuf buf, String string) {
        byte[] strData = string.getBytes(StandardCharsets.UTF_8);
        BufUtils.writeVarInt(buf, strData.length);
        buf.writeBytes(strData);
    }
}

