/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ru.dimaskama.webcam.config.JsonConfig;
import ru.dimaskama.webcam.config.MessagesConfig;
import ru.dimaskama.webcam.config.SyncedServerConfig;
import ru.dimaskama.webcam.config.VideoDisplayShape;

public record ServerConfig(int port, String bindAddress, String host, int keepAlivePeriod, int permissionCheckPeriod, double maxDisplayDistance, boolean displayOnFace, VideoDisplayShape displayShape, float displayOffsetY, float displaySize, boolean hideNicknames, boolean displaySelfWebcam, SyncedServerConfig synced, MessagesConfig messages) {
    public static final double MIN_MAX_DISPLAY_DISTANCE = 5.0;
    public static final double MAX_MAX_DISPLAY_DISTANCE = 100000.0;
    public static final float MIN_DISPLAY_OFFSET_Y = -10.0f;
    public static final float MAX_DISPLAY_OFFSET_Y = 100.0f;
    public static final float MIN_DISPLAY_SIZE = 0.1f;
    public static final float MAX_DISPLAY_SIZE = 200.0f;
    private static final int DEFAULT_PORT = 25454;
    public static final Codec<ServerConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)JsonConfig.defaultedField(Codec.intRange((int)1, (int)65535), "port", () -> 25454).forGetter(ServerConfig::port), (App)JsonConfig.defaultedField(Codec.STRING, "bind_address", () -> "").forGetter(ServerConfig::bindAddress), (App)JsonConfig.defaultedField(Codec.STRING, "host", () -> "").forGetter(ServerConfig::host), (App)JsonConfig.defaultedField(Codec.intRange((int)100, (int)100000), "keep_alive_period", () -> 1000).forGetter(ServerConfig::keepAlivePeriod), (App)JsonConfig.defaultedField(Codec.intRange((int)1, (int)100000), "permission_check_period", () -> 60).forGetter(ServerConfig::permissionCheckPeriod), (App)JsonConfig.defaultedField(Codec.doubleRange((double)5.0, (double)100000.0), "max_display_distance", () -> 100.0).forGetter(ServerConfig::maxDisplayDistance), (App)JsonConfig.defaultedField(Codec.BOOL, "display_on_face", () -> false).forGetter(ServerConfig::displayOnFace), (App)JsonConfig.defaultedField(VideoDisplayShape.CODEC, "display_shape", () -> VideoDisplayShape.ROUND).forGetter(ServerConfig::displayShape), (App)JsonConfig.defaultedField(Codec.floatRange((float)-10.0f, (float)100.0f), "display_offset_y", () -> Float.valueOf(1.3f)).forGetter(ServerConfig::displayOffsetY), (App)JsonConfig.defaultedField(Codec.floatRange((float)0.1f, (float)200.0f), "display_size", () -> Float.valueOf(1.2f)).forGetter(ServerConfig::displaySize), (App)JsonConfig.defaultedField(Codec.BOOL, "hide_nicknames", () -> true).forGetter(ServerConfig::hideNicknames), (App)JsonConfig.defaultedField(Codec.BOOL, "display_self_webcam", () -> true).forGetter(ServerConfig::displaySelfWebcam), (App)JsonConfig.defaultedField(SyncedServerConfig.CODEC, "synced", SyncedServerConfig::new).forGetter(ServerConfig::synced), (App)JsonConfig.defaultedField(MessagesConfig.CODEC, "messages", MessagesConfig::new).forGetter(ServerConfig::messages)).apply((Applicative)instance, ServerConfig::new));

    public ServerConfig() {
        this(25454, "", "", 1000, 60, 100.0, false, VideoDisplayShape.ROUND, 1.3f, 1.2f, true, true, new SyncedServerConfig(), new MessagesConfig());
    }

    public ServerConfig withPort(int port) {
        return new ServerConfig(port, this.bindAddress, this.host, this.keepAlivePeriod, this.permissionCheckPeriod, this.maxDisplayDistance, this.displayOnFace, this.displayShape, this.displayOffsetY, this.displaySize, this.hideNicknames, this.displaySelfWebcam, this.synced, this.messages);
    }

    public ServerConfig withBindAddress(String bindAddress) {
        return new ServerConfig(this.port, bindAddress, this.host, this.keepAlivePeriod, this.permissionCheckPeriod, this.maxDisplayDistance, this.displayOnFace, this.displayShape, this.displayOffsetY, this.displaySize, this.hideNicknames, this.displaySelfWebcam, this.synced, this.messages);
    }

    public ServerConfig withHost(String host) {
        return new ServerConfig(this.port, this.bindAddress, host, this.keepAlivePeriod, this.permissionCheckPeriod, this.maxDisplayDistance, this.displayOnFace, this.displayShape, this.displayOffsetY, this.displaySize, this.hideNicknames, this.displaySelfWebcam, this.synced, this.messages);
    }

    public ServerConfig withKeepAlivePeriod(int keepAlivePeriod) {
        return new ServerConfig(this.port, this.bindAddress, this.host, keepAlivePeriod, this.permissionCheckPeriod, this.maxDisplayDistance, this.displayOnFace, this.displayShape, this.displayOffsetY, this.displaySize, this.hideNicknames, this.displaySelfWebcam, this.synced, this.messages);
    }

    public ServerConfig withPermissionCheckPeriod(int permissionCheckPeriod) {
        return new ServerConfig(this.port, this.bindAddress, this.host, this.keepAlivePeriod, permissionCheckPeriod, this.maxDisplayDistance, this.displayOnFace, this.displayShape, this.displayOffsetY, this.displaySize, this.hideNicknames, this.displaySelfWebcam, this.synced, this.messages);
    }

    public ServerConfig withMaxDisplayDistance(double maxDisplayDistance) {
        return new ServerConfig(this.port, this.bindAddress, this.host, this.keepAlivePeriod, this.permissionCheckPeriod, maxDisplayDistance, this.displayOnFace, this.displayShape, this.displayOffsetY, this.displaySize, this.hideNicknames, this.displaySelfWebcam, this.synced, this.messages);
    }

    public ServerConfig withDisplayOnFace(boolean displayOnFace) {
        return new ServerConfig(this.port, this.bindAddress, this.host, this.keepAlivePeriod, this.permissionCheckPeriod, this.maxDisplayDistance, displayOnFace, this.displayShape, this.displayOffsetY, this.displaySize, this.hideNicknames, this.displaySelfWebcam, this.synced, this.messages);
    }

    public ServerConfig withDisplayShape(VideoDisplayShape displayShape) {
        return new ServerConfig(this.port, this.bindAddress, this.host, this.keepAlivePeriod, this.permissionCheckPeriod, this.maxDisplayDistance, this.displayOnFace, displayShape, this.displayOffsetY, this.displaySize, this.hideNicknames, this.displaySelfWebcam, this.synced, this.messages);
    }

    public ServerConfig withDisplayOffsetY(float displayOffsetY) {
        return new ServerConfig(this.port, this.bindAddress, this.host, this.keepAlivePeriod, this.permissionCheckPeriod, this.maxDisplayDistance, this.displayOnFace, this.displayShape, displayOffsetY, this.displaySize, this.hideNicknames, this.displaySelfWebcam, this.synced, this.messages);
    }

    public ServerConfig withDisplaySize(float displaySize) {
        return new ServerConfig(this.port, this.bindAddress, this.host, this.keepAlivePeriod, this.permissionCheckPeriod, this.maxDisplayDistance, this.displayOnFace, this.displayShape, this.displayOffsetY, displaySize, this.hideNicknames, this.displaySelfWebcam, this.synced, this.messages);
    }

    public ServerConfig withHideNicknames(boolean hideNicknames) {
        return new ServerConfig(this.port, this.bindAddress, this.host, this.keepAlivePeriod, this.permissionCheckPeriod, this.maxDisplayDistance, this.displayOnFace, this.displayShape, this.displayOffsetY, this.displaySize, hideNicknames, this.displaySelfWebcam, this.synced, this.messages);
    }

    public ServerConfig withDisplaySelfWebcam(boolean displaySelfWebcam) {
        return new ServerConfig(this.port, this.bindAddress, this.host, this.keepAlivePeriod, this.permissionCheckPeriod, this.maxDisplayDistance, this.displayOnFace, this.displayShape, this.displayOffsetY, this.displaySize, this.hideNicknames, displaySelfWebcam, this.synced, this.messages);
    }

    public ServerConfig withSynced(SyncedServerConfig synced) {
        return new ServerConfig(this.port, this.bindAddress, this.host, this.keepAlivePeriod, this.permissionCheckPeriod, this.maxDisplayDistance, this.displayOnFace, this.displayShape, this.displayOffsetY, this.displaySize, this.hideNicknames, this.displaySelfWebcam, synced, this.messages);
    }
}

