/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.render;

import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import ru.dimaskama.webcam.client.render.WebcamRenderTypes;
import ru.dimaskama.webcam.config.VideoDisplayShape;

public class WebcamRenderer {
    public static void render(class_2960 textureId, class_4587.class_4665 pose, class_4597 consumers, float halfWidth, float halfHeight, VideoDisplayShape shape) {
        switch (shape) {
            case SQUARE: {
                WebcamRenderer.renderSquare(textureId, pose, consumers, halfWidth, halfHeight);
                break;
            }
            case ROUND: {
                WebcamRenderer.renderRound(textureId, pose, consumers, halfWidth, halfHeight);
            }
        }
    }

    public static void renderSquare(class_2960 textureId, class_4587.class_4665 pose, class_4597 consumers, float halfWidth, float halfHeight) {
        class_4588 consumer = consumers.getBuffer(WebcamRenderTypes.square(textureId));
        consumer.method_56824(pose, -halfWidth, -halfHeight, 0.0f).method_22913(0.0f, 0.0f);
        consumer.method_56824(pose, -halfWidth, halfHeight, 0.0f).method_22913(0.0f, 1.0f);
        consumer.method_56824(pose, halfWidth, halfHeight, 0.0f).method_22913(1.0f, 1.0f);
        consumer.method_56824(pose, halfWidth, -halfHeight, 0.0f).method_22913(1.0f, 0.0f);
    }

    public static void renderRound(class_2960 textureId, class_4587.class_4665 pose, class_4597 consumers, float halfWidth, float halfHeight) {
        class_4588 consumer = consumers.getBuffer(WebcamRenderTypes.round(textureId));
        int numVertices = class_3532.method_15340((int)Math.round(50.265484f * halfWidth), (int)48, (int)360);
        consumer.method_56824(pose, 0.0f, 0.0f, 0.0f).method_22913(0.5f, 0.5f);
        for (int i = 0; i <= numVertices; ++i) {
            float angle = (float)Math.PI * 2 * (float)i / (float)numVertices;
            float x = class_3532.method_15362((float)angle);
            float y = -class_3532.method_15374((float)angle);
            consumer.method_56824(pose, halfWidth * x, halfHeight * y, 0.0f).method_22913(0.5f * (x + 1.0f), 0.5f * (y + 1.0f));
        }
    }
}

