/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client;

import java.io.IOException;
import net.minecraft.class_2561;
import ru.dimaskama.javah264.H264Encoder;
import ru.dimaskama.javah264.exception.EncoderException;
import ru.dimaskama.javah264.exception.UnknownPlatformException;
import ru.dimaskama.webcam.client.cap.DeviceException;

public class AdaptableH264Encoder {
    private volatile int fps = -1;
    private volatile int mtu = -1;
    private volatile int bitrate = -1;
    private volatile H264Encoder encoder;

    private static H264Encoder createEncoder(int fps, int mtu, int bitrate) {
        try {
            return H264Encoder.builder().profile(H264Encoder.Profile.Main).rateControlMode(H264Encoder.RateControlMode.Bitrate).spsPpsStrategy(H264Encoder.SpsPpsStrategy.IncreasingId).multipleThreadIdc((short)1).maxFrameRate(fps).maxSliceLen(mtu).targetBitrate(bitrate * 1000).intraFramePeriod(3 * fps).build();
        }
        catch (IOException | UnknownPlatformException e) {
            throw new RuntimeException("Failed to create H.264 encoder", e);
        }
    }

    public synchronized byte[][] encode(int fps, int mtu, int bitrate, int width, int height, byte[] rgba) throws DeviceException {
        if (this.fps != fps || this.mtu != mtu || this.bitrate != bitrate) {
            if (this.encoder != null) {
                this.encoder.close();
            }
            this.encoder = AdaptableH264Encoder.createEncoder(fps, mtu, bitrate);
            this.fps = fps;
            this.mtu = mtu;
            this.bitrate = bitrate;
        }
        try {
            return this.encoder.encodeSeparateRGBA(width, height, rgba);
        }
        catch (EncoderException e) {
            throw new DeviceException((class_2561)class_2561.method_43471((String)"webcam.error.encode_error"), (Throwable)e);
        }
    }

    public synchronized void close() {
        H264Encoder encoder = this.encoder;
        if (encoder != null) {
            this.encoder = null;
            this.mtu = -1;
            this.fps = -1;
            this.bitrate = -1;
            encoder.close();
        }
    }
}

