/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.javah264;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;
import ru.dimaskama.javah264.OpenH264Lib;
import ru.dimaskama.javah264.exception.EncoderException;
import ru.dimaskama.javah264.exception.UnknownPlatformException;

public class H264Encoder
implements AutoCloseable {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final long pointer;

    public H264Encoder() throws IOException, UnknownPlatformException {
        this(new Builder());
    }

    public H264Encoder(Builder builder) throws IOException, UnknownPlatformException {
        OpenH264Lib.load();
        this.pointer = H264Encoder.createEncoder0(builder.enableSkipFrame, builder.targetBitrate, builder.maxFrameRate, builder.rateControlMode.ordinal(), builder.spsPpsStrategy.ordinal(), builder.multipleThreadIdc, builder.usageType.ordinal(), builder.maxSliceLen != null ? builder.maxSliceLen : -1, builder.profile != null ? builder.profile.ordinal() : -1, builder.level != null ? builder.level.ordinal() : -1, builder.complexity.ordinal(), builder.minQp, builder.maxQp, builder.sceneChangeDetect, builder.adaptiveQuantization, builder.backgroundDetection, builder.longTermReference, builder.intraFramePeriod);
    }

    public static Builder builder() {
        return new Builder();
    }

    public byte[] encodeRGBA(int width, int height, byte[] rgba) throws EncoderException {
        this.assertNotClosed();
        this.checkDims(width, height, 4, rgba.length);
        return H264Encoder.encodeRGBA0(this.pointer, width, height, rgba);
    }

    public byte[] encodeRGB(int width, int height, byte[] rgb) throws EncoderException {
        this.assertNotClosed();
        this.checkDims(width, height, 3, rgb.length);
        return H264Encoder.encodeRGB0(this.pointer, width, height, rgb);
    }

    public byte[][] encodeSeparateRGBA(int width, int height, byte[] rgba) throws EncoderException {
        this.assertNotClosed();
        this.checkDims(width, height, 4, rgba.length);
        return H264Encoder.encodeSeparateRGBA0(this.pointer, width, height, rgba);
    }

    public byte[][] encodeSeparateRGB(int width, int height, byte[] rgb) throws EncoderException {
        this.assertNotClosed();
        this.checkDims(width, height, 3, rgb.length);
        return H264Encoder.encodeSeparateRGB0(this.pointer, width, height, rgb);
    }

    private void checkDims(int width, int height, int pixelLen, int dataLength) {
        if (width < 16) {
            throw new IllegalArgumentException("Width cannot be < 16: " + width);
        }
        if (height < 16) {
            throw new IllegalArgumentException("Height cannot be < 16: " + height);
        }
        if (width * height * pixelLen != dataLength) {
            throw new IllegalArgumentException("width * height * " + pixelLen + " != image data length");
        }
        if ((width & 1) != 0) {
            throw new IllegalArgumentException("Width needs to be a multiple of 2");
        }
        if ((height & 1) != 0) {
            throw new IllegalArgumentException("Height needs to be a multiple of 2");
        }
    }

    private void assertNotClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("This H264Encoder instance is closed!");
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            H264Encoder.destroyEncoder0(this.pointer);
        }
    }

    private static native long createEncoder0(boolean var0, int var1, float var2, int var3, int var4, short var5, int var6, int var7, int var8, int var9, int var10, byte var11, byte var12, boolean var13, boolean var14, boolean var15, boolean var16, int var17);

    private static native byte[] encodeRGBA0(long var0, int var2, int var3, byte[] var4) throws EncoderException;

    private static native byte[] encodeRGB0(long var0, int var2, int var3, byte[] var4) throws EncoderException;

    private static native byte[][] encodeSeparateRGBA0(long var0, int var2, int var3, byte[] var4) throws EncoderException;

    private static native byte[][] encodeSeparateRGB0(long var0, int var2, int var3, byte[] var4) throws EncoderException;

    private static native void destroyEncoder0(long var0);

    public static enum Complexity {
        Low,
        Medium,
        High;

    }

    public static enum Level {
        Level_1_0,
        Level_1_B,
        Level_1_1,
        Level_1_2,
        Level_1_3,
        Level_2_0,
        Level_2_1,
        Level_2_2,
        Level_3_0,
        Level_3_1,
        Level_3_2,
        Level_4_0,
        Level_4_1,
        Level_4_2,
        Level_5_0,
        Level_5_1,
        Level_5_2;

    }

    public static enum Profile {
        Baseline,
        Main,
        Extended,
        High,
        High10,
        High422,
        High444,
        CAVLC444,
        ScalableBaseline,
        ScalableHigh;

    }

    public static enum UsageType {
        CameraVideoRealTime,
        ScreenContentRealTime,
        CameraVideoNonRealTime,
        ScreenContentNonRealTime,
        InputContentTypeAll;

    }

    public static enum SpsPpsStrategy {
        ConstantId,
        IncreasingId,
        SpsListing,
        SpsListingAndPpsIncreasing,
        SpsPpsListing;

    }

    public static enum RateControlMode {
        Quality,
        Bitrate,
        Bufferbased,
        Timestamp,
        BitrateModePostSkip,
        Off;

    }

    public static class Builder {
        private boolean enableSkipFrame = true;
        private int targetBitrate = 120000;
        private float maxFrameRate = 0.0f;
        private RateControlMode rateControlMode = RateControlMode.Quality;
        private SpsPpsStrategy spsPpsStrategy = SpsPpsStrategy.ConstantId;
        private short multipleThreadIdc = 0;
        private UsageType usageType = UsageType.CameraVideoRealTime;
        @Nullable
        private Integer maxSliceLen = null;
        @Nullable
        private Profile profile = null;
        @Nullable
        private Level level = null;
        private Complexity complexity = Complexity.Medium;
        private byte minQp = 0;
        private byte maxQp = (byte)51;
        private boolean sceneChangeDetect = true;
        private boolean adaptiveQuantization = true;
        private boolean backgroundDetection = true;
        private boolean longTermReference = false;
        private int intraFramePeriod = 0;

        private Builder() {
        }

        public Builder enableSkipFrame(boolean value) {
            this.enableSkipFrame = value;
            return this;
        }

        public Builder targetBitrate(int value) {
            this.targetBitrate = value;
            return this;
        }

        public Builder maxFrameRate(float value) {
            this.maxFrameRate = value;
            return this;
        }

        public Builder rateControlMode(RateControlMode value) {
            this.rateControlMode = value;
            return this;
        }

        public Builder spsPpsStrategy(SpsPpsStrategy value) {
            this.spsPpsStrategy = value;
            return this;
        }

        public Builder multipleThreadIdc(short value) {
            this.multipleThreadIdc = value;
            return this;
        }

        public Builder usageType(UsageType value) {
            this.usageType = value;
            return this;
        }

        public Builder maxSliceLen(int value) {
            this.maxSliceLen = value;
            return this;
        }

        public Builder profile(Profile value) {
            this.profile = value;
            return this;
        }

        public Builder level(Level value) {
            this.level = value;
            return this;
        }

        public Builder complexity(Complexity value) {
            this.complexity = value;
            return this;
        }

        public Builder minQp(byte value) {
            this.minQp = value;
            return this;
        }

        public Builder maxQp(byte value) {
            this.maxQp = value;
            return this;
        }

        public Builder sceneChangeDetect(boolean value) {
            this.sceneChangeDetect = value;
            return this;
        }

        public Builder adaptiveQuantization(boolean value) {
            this.adaptiveQuantization = value;
            return this;
        }

        public Builder backgroundDetection(boolean value) {
            this.backgroundDetection = value;
            return this;
        }

        public Builder longTermReference(boolean value) {
            this.longTermReference = value;
            return this;
        }

        public Builder intraFramePeriod(int value) {
            this.intraFramePeriod = value;
            return this;
        }

        public H264Encoder build() throws IOException, UnknownPlatformException {
            return new H264Encoder(this);
        }
    }
}

