/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.textparser;

import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.parsers.TagLikeParser;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang3.tuple.Pair;

public class MultiTagLikeParser
extends TagLikeParser {
    private final Pair<TagLikeParser.Format, TagLikeParser.Provider>[] pairs;

    public MultiTagLikeParser(Pair<TagLikeParser.Format, TagLikeParser.Provider>[] formatsAndProviders) {
        Pair<TagLikeParser.Format, TagLikeParser.Provider>[] copy = Arrays.copyOf(formatsAndProviders, formatsAndProviders.length);
        Arrays.sort(copy, Comparator.comparingInt(p -> ((TagLikeParser.Format)p.getLeft()).index()));
        this.pairs = copy;
    }

    @Override
    protected void handleLiteral(String value, TagLikeParser.Context context) {
        int pos = 0;
        while (pos != -1) {
            TagLikeParser.Provider provider = null;
            TagLikeParser.Format.Tag tag = null;
            for (int tPos = pos; tPos < value.length(); ++tPos) {
                for (Pair<TagLikeParser.Format, TagLikeParser.Provider> p : this.pairs) {
                    TagLikeParser.Format.Tag tag1 = ((TagLikeParser.Format)p.getLeft()).findAt(value, tPos, (TagLikeParser.Provider)p.getRight(), context);
                    if (tag1 == null || tag != null && tag1.start() >= tag.start()) continue;
                    provider = (TagLikeParser.Provider)p.getRight();
                    tag = tag1;
                }
                if (tag != null) break;
                if (value.charAt(tPos) != '\\' || value.length() <= tPos + 1) continue;
                ++tPos;
            }
            if (provider != null) {
                pos = this.handleTag(value, pos, tag, provider, context);
                continue;
            }
            context.addNode(new LiteralNode(value.substring(pos)));
            pos = -1;
        }
    }

    public Pair<TagLikeParser.Format, TagLikeParser.Provider>[] pairs() {
        return this.pairs;
    }
}

