/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.node.parent;

import com.mojang.serialization.DataResult;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.DynamicShadowNode;
import eu.pb4.placeholders.api.node.parent.ParentTextNode;
import eu.pb4.placeholders.api.node.parent.SimpleStylingNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;

public final class DynamicColorNode
extends SimpleStylingNode
implements DynamicShadowNode.SimpleColoredTransformer {
    private static final Function<String, class_5251> DEFAULT_RESOLVER = string -> class_5251.method_27719((String)string).result().orElse(null);
    private final TextNode color;
    private final Function<String, class_5251> resolver;

    public DynamicColorNode(TextNode[] children, TextNode color) {
        this(children, color, DEFAULT_RESOLVER);
    }

    public DynamicColorNode(TextNode[] children, TextNode color, Function<String, @Nullable class_5251> resolver) {
        super(children);
        this.color = color;
        this.resolver = resolver;
    }

    public static Function<String, @Nullable class_5251> extendedTextColorParse(Function<String, @Nullable class_5251> resolver) {
        return string -> {
            class_5251 x = (class_5251)resolver.apply((String)string);
            if (x != null) {
                return x;
            }
            return class_5251.method_27719((String)string).result().orElse(null);
        };
    }

    @Override
    public boolean isDynamicNoChildren() {
        return this.color.isDynamic();
    }

    @Override
    protected class_2583 style(ParserContext context) {
        class_5251 c = this.resolver.apply(this.color.toText(context).getString());
        return c != null ? class_2583.field_24360.method_27703(c) : class_2583.field_24360;
    }

    @Override
    public ParentTextNode copyWith(TextNode[] children) {
        return new DynamicColorNode(children, this.color);
    }

    @Override
    public ParentTextNode copyWith(TextNode[] children, NodeParser parser) {
        return new DynamicColorNode(children, parser.parseNode(this.color));
    }

    @Override
    public String toString() {
        return "ColorNode{color=" + String.valueOf(this.color) + ", children=" + Arrays.toString(this.children) + "}";
    }

    @Override
    public int getDefaultShadowColor(class_2561 out, float scale, float alpha, ParserContext context) {
        DataResult color = class_5251.method_27719((String)this.color.toText(context).getString());
        if (color.result().isPresent()) {
            return DynamicShadowNode.modifiedColor(((class_5251)color.getOrThrow()).method_27716(), scale, alpha);
        }
        return 0;
    }

    @Override
    public boolean hasShadowColor(ParserContext context) {
        return class_5251.method_27719((String)this.color.toText(context).getString()).result().isPresent();
    }
}

